function P82_ii
% Problem 8.2 :	The growth/decay of population of animal species
% ii. Show x_n converges to (r-1)/r when 1<r<2.

% Choose arbitrary r between 1 and 2
r=[1.3 1.5 1.7 1.9];
% Set initial population matrix 
x0=[0.1:0.1:0.9]';
% Set the population year
nf=30;
% Define color setr
col={'r' ; 'b' ; 'g' ; 'm'};

figure(1);
for j=1:length(r)
    % Set the normalized population matrix
    % row: different initial populatipon
    % column: population year n
    xn=zeros(length(x0),nf);
    % Calculate the quadratic recurrence equation 
    x=x0;
    for i=1:nf
        xn(:,i)=r(j)*x.*(1-x);
        x=xn(:,i);
    end
    % Plot the normalized population for n
    subplot(2,2,j);
    figure(1);
    h=plot(0:nf,[x0 xn],[col{j} 's-']);
    set(h,'MarkerSize',6);
    set(gca,'FontSize',18);
    grid on; axis tight;
    xlabel('\bfThe population at year (a.u.)');
    ylabel('\bfThe normalized population x_n (a.u.)');
    title(['\bfThe Normalized Population for r=' num2str(r(j))]);
    % Display final values which the population approaches to
    fprintf('%d. r=%f\n',j,r(j));
    fprintf('the population approaches to %f\n',mean(xn(:,end)));
end
end